/************************************************************************
 *
 * \file: ServerMonitor.h
 *
 * \version: $Id:$
 *
 * \release: $Name:$
 *
 * <brief description>.
 * <detailed description>
 * \component: Android Auto - Demo application
 *
 * \author: J. Harder / ADITG/SW1 / jharder@de.adit-jv.com
 *
 * \copyright (c) 2015 Advanced Driver Information Technology.
 * This code is developed by Advanced Driver Information Technology.
 * Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
 * All rights reserved.
 *
 * \see <related items>
 *
 * \history
 *
 ***********************************************************************/

#ifndef AAUTOT_SERVERMONITOR_H
#define AAUTOT_SERVERMONITOR_H

#include <map>
#include <string>
#include <memory>
#include <aauto/AoapTransport.h>
#include "utils/DeviceMonitor.h"
#include "utils/UsbDeviceId.h"

#include <uspi/FeatureDiscoveryTypes.h>

namespace adit { namespace aauto {

class ServerMonitor : public DeviceMonitor
{
public:
    void onDeviceFound(std::shared_ptr<adit::uspi::DiscoveredDeviceUsb> inUsbDevice);
    void onDeviceSwitched(std::shared_ptr<adit::uspi::DiscoveredDeviceUsb> inUsbDevice);
    void onDeviceLost(std::shared_ptr<adit::uspi::DiscoveredDeviceUsb> inUsbDevice);
    void onDeviceChanged(std::shared_ptr<adit::uspi::DiscoveredDeviceUsb> inUsbDevice);
    void onDeviceError(adit::uspi::DiscoveryError inErrorCode);

private:
    std::map<std::string, aoapTransportInfo_t> transportInfos;
};


} } /* namespace adit { namespace aauto */
#endif /* AAUTOT_SERVERMONITOR_H */
